/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.embedded_tomcat;

import java.util.Enumeration;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Embedded;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EmbeddedTomcat {
    protected static boolean enableSymlinks = false;
    protected String catalinaHome;
    protected Host host;
    protected Embedded container;

    public void addHttpListener(int port, int maxPostSize, int maxThreads, boolean secure, String algorithm) {
        Connector connector = this.container.createConnector(null, port, secure);
        if (secure && algorithm != null) {
            connector.setAttribute("algorithm", (Object)algorithm);
        }
        connector.setMaxPostSize(maxPostSize);
        connector.setProperty("maxThreads", String.valueOf(maxThreads));
        this.container.addConnector(connector);
    }

    public void registerContext(ContextConfig cc) throws Exception {
        this.registerContext(cc.contextPath, cc.baseDir);
    }

    public void registerContext(String contextPath, String baseDir) {
        if (contextPath.equalsIgnoreCase("root") || contextPath.equalsIgnoreCase("/root")) {
            contextPath = "/";
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        Context context = this.container.createContext(contextPath, baseDir);
        context.setLoader(this.container.createLoader(null));
        context.setReloadable(true);
        if (enableSymlinks) {
            ((StandardContext)context).setAllowLinking(true);
        }
        this.host.addChild((Container)context);
    }

    public void unregisterContext(String contextPath) throws Exception {
        Context context = this.host.map(contextPath);
        if (context != null) {
            this.container.removeContext(context);
        }
    }

    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        String cmdLineSyntax = "EmbeddedTomcat [options]";
        Options options = new Options();
        options.addOption("h", "help", false, "Show usage message and exit");
        OptionBuilder.withLongOpt((String)"catalinaHome");
        OptionBuilder.withDescription((String)"Base Catalina directory (CATALINA_HOME)");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withArgName((String)"dir");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"war");
        OptionBuilder.withDescription((String)"Add a WAR deployment with the specified contextPath and baseDir");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withArgName((String)"contextPath=baseDir");
        options.addOption(OptionBuilder.create((char)'w'));
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.withDescription((String)"HTTP port number to listen on");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"securePort");
        OptionBuilder.withDescription((String)"HTTPS port number to listen on");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"secureAlgorithm");
        OptionBuilder.withDescription((String)"Set to: IbmX509 if using IBM JDK");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'a'));
        OptionBuilder.withLongOpt((String)"hostname");
        OptionBuilder.withDescription((String)"Hostname");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.withLongOpt((String)"maxThreads");
        OptionBuilder.withDescription((String)"Max request processing threads");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"maxPostSize");
        OptionBuilder.withDescription((String)"Max size of POST request");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator((char)' ');
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"enableSymlinks");
        OptionBuilder.withDescription((String)"Set this parameter to enable symlink resolution in all deployed webapps (sets allowLinking attribute in Tomcat to true).  Do NOT set this on windows. For more info: http://jakarta.apache.org/tomcat/tomcat-5.0-doc/config/context.html");
        options.addOption(OptionBuilder.create((char)'l'));
        CommandLine line = parser.parse(options, args);
        if (line.hasOption('h')) {
            EmbeddedTomcat.outputHelp(cmdLineSyntax, options);
            System.exit(0);
        }
        String hostname = "localhost";
        if (line.hasOption('n')) {
            hostname = line.getOptionValue('n');
        }
        if (line.hasOption('l')) {
            enableSymlinks = true;
        }
        String catalinaHome = null;
        if (line.hasOption('c')) {
            catalinaHome = line.getOptionValue('c');
        }
        int port = 8080;
        if (line.hasOption('p')) {
            port = Integer.parseInt(line.getOptionValue('p'));
        }
        int maxPostSize = 0x200000;
        if (line.hasOption("maxPostSize")) {
            maxPostSize = Integer.parseInt(line.getOptionValue("maxPostSize"));
        }
        int maxThreads = 200;
        if (line.hasOption("maxThreads")) {
            maxThreads = Integer.parseInt(line.getOptionValue("maxThreads"));
        }
        EmbeddedTomcat tomcat = new EmbeddedTomcat(catalinaHome, hostname);
        tomcat.addHttpListener(port, maxPostSize, maxThreads, false, null);
        if (line.hasOption('s')) {
            int securePort = Integer.parseInt(line.getOptionValue('s'));
            String algorithm = null;
            if (line.hasOption('a')) {
                algorithm = line.getOptionValue('a');
            }
            tomcat.addHttpListener(securePort, maxPostSize, maxThreads, true, algorithm);
        }
        if (line.hasOption("w")) {
            String[] wars = line.getOptionValues("w");
            int i = 0;
            while (i < wars.length) {
                String warString = wars[i];
                int sepIndex = warString.indexOf("=");
                if (sepIndex == -1) {
                    throw new Exception("format for --war is: contextPath=baseDir");
                }
                ContextConfig cc = new ContextConfig(warString.substring(0, sepIndex), warString.substring(sepIndex + 1, warString.length()));
                tomcat.registerContext(cc);
                ++i;
            }
        }
        tomcat.container.start();
        while (true) {
            Thread.sleep(60000L);
        }
    }

    public static void outputHelp(String cmdLineSyntax, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(cmdLineSyntax, "", options, "");
    }

    private final /* synthetic */ void this() {
        this.catalinaHome = null;
        this.host = null;
        this.container = null;
    }

    public EmbeddedTomcat(String catalinaHome, String hostname) {
        this.this();
        this.catalinaHome = catalinaHome;
        System.setProperty("catalina.home", catalinaHome);
        this.container = new Embedded();
        this.host = this.container.createHost(hostname, catalinaHome + "/webapps");
        Engine engine = null;
        engine = this.container.createEngine();
        engine.setDefaultHost(hostname);
        engine.addChild((Container)this.host);
        this.container.addEngine(engine);
    }

    static {
        try {
            System.setProperty("log4j.configuration", "log4j-embeddedTomcat.isc.config.xml");
            Logger rootLogger = Logger.getRootLogger();
            Enumeration e = rootLogger.getAllAppenders();
            if (!e.hasMoreElements()) {
                rootLogger.addAppender((Appender)new NullAppender());
            }
        }
        catch (Throwable t) {
            System.out.println("Unable to call System.setProperty() - Isomorphic's log4j default configuration will not be available." + t.getMessage());
        }
    }

    public static class ContextConfig {
        public String contextPath;
        public String baseDir;
        public Context context;

        public ContextConfig(String contextPath, String baseDir) throws Exception {
            this.contextPath = contextPath;
            this.baseDir = baseDir;
        }
    }
}

